'           V.1   89c2051 simple multicounter
'     frequency range      1Hz 400KHz
'     period range         100uS to 8S
'

$regfile = "REG51.DAT"                                         ' "REG51.DAT" "8052.DAT"
'$large
'$baud = 9600
$crystal = 12000000                                           '  11059200
$noramclear
'
'
'              constant
'
Const Xtal = 12000000
Const T0_ck = Xtal / 12                                       ' 1e6Hz
Const T0_load = T0_ck / 5000                                  ' 5KHz = 200uS
Const ktacho = 60e7                                           'rpm conversion
Const kfreq = 1e7                                             'frequency conversion
'
Const P1dis = &B00011000                                      'disable port P1
Const LedOn = 0                                               'led acceso
Const LedOff = 1                                              'led spento
Const MaskTasti = &B00011000                                  'P1 button mask
Const Tast_OK = &B00001000                                    'Ok button           P1.1
Const Tast_Scroll = &B00010000                                'menu scroll button  P1.0
'
'
Dim Fl_Err As Bit                                             'error timeout
Dim Fl_User As Bit                                            'user quit
Dim Fl_Phase As Bit                                           'fase misura periodo
Dim Fl_Done As Bit                                            'data available
'
Dim Tmp1 As Byte
Dim Txx As Byte
Dim Tasti As Byte
Dim Hicntr As Byte                                            'hi counter
Dim TmpLong As Long                                           '24 bit period counter
Dim TmpW As Word

Ta_Ok Alias P1.3                                              'pin 13          button
Ta_Menu Alias P1.4                                            'pin 12          button
'
'
LedM Alias P3.7                                               'pin 11

'
'.............................
'
'
 config Lcd = 16 * 2
 config LCDPIN = PIN , RS = P1.2 , E = P1.0 , DB4 = P0.4 , DB5 = P0.5 , DB6 = P0.6 , DB7 = P0.7
 config Timer0 = Timer , Gate = Internal , Mode = 2
'
'
'Priority Set Int0              'INT0 has by default the highest priority
'
        P1 = P1dis
         On Int0 Int0_int nosave
         load timer0 , T0_load                                'autorealod 200uS
         waitms 100
         cls
         waitms 2
         cursor off
         waitms 2
Menu:
         cls
         waitms 2
         lcd " M.counter V.1"
         ledM = LedOff
         call Tastoff                                         'rilascio
         locate 2 , 1
         waitms 2
         lcd " Sel.func."
         do
           call Detasti
         loop until Tasti > 0                                 'ricontrolla tasti
         Tmp1 = 0                                             'voce menu selezione
'
Const NuVoci = 3                                              'voci del menu
'
         do
           locate 2 , 1
           waitms 2
           select case Tmp1
'                           -----1234567890123456----
                case 0 :
                            lcd "  Frequency"
                case 1 :
                            lcd "  Period"
                case 2 :
                            lcd "  Low Freq."
                case 3 :
                            lcd "  Tachometer"
           end select
           call Clean
           call Tastoff                                       'attende rilascio tasto
           call Taston                                        'tasti premuti ?
           if Tasti = Tast_Scroll then incr Tmp1              'scroll voce
           if Tasti = Tast_OK then exit do                    'conferma voce
           call Tastoff
           if Tmp1 > NuVoci then Tmp1 = 0                     'roll voci menu
         loop
         call Tastoff
'
  on Tmp1 goto Tk0 , Tk1 , Tk2 , Tk3                          ',Tk4,tk5,tk6,tk7
'
'
'
Tk0:
       config Timer1 = Counter , Gate = Internal , Mode = 1
      do
          call F_Measure
          call GoHome
          lcd TmpLong ; " Hz"
          call Clean
          waitms 500
      loop until Ta_OK = 0
       goto menu
'
'
Tk1:
        config Timer1 = Timer , Gate = Internal , Mode = 1
       do
         call P_Measure                                       'measure period
         if Fl_User = 1 then exit do
         if Fl_Err = 0 then                                   'timeout
            call GoHome
            lcd TmpLong ; " uS"
            call Clean
            wait 1                                            'display time
         else
             call Too_long                                    'timeout
         endif
       loop until Ta_Ok = 0                                   'user quit
        goto menu
'
'
Tk2:
        config Timer1 = Timer , Gate = Internal , Mode = 1
       do
         call P_Measure                                       'measure period
         if Fl_User = 1 then exit do
         if Fl_Err = 0 then                                   'timeout
'freq = 1e7/periodo                         '1 decimale
            TmpLong = kfreq / TmpLong
            call GoHome
            call Conv_displ
            lcd " Hz"
            call Clean
            wait 1                                            'refresh rate
         else
            call Too_long                                     'timeout
         endif
       loop until Ta_Ok = 0                                   'user quit
        goto menu
'
'
Tk3:
        config Timer1 = Timer , Gate = Internal , Mode = 1
       do
         call P_Measure                                       'measure period
         if Fl_User = 1 then exit do
         if Fl_Err = 0 then                                   'timeout
'rpm = 60e7/periodo
            TmpLong = ktacho / TmpLong                        '1 decimale
            call GoHome
            call Conv_displ
            lcd " Rpm"
            call Clean
            wait 1                                            'display time
         else
            call Too_long                                     'timeout
         endif
       loop until Ta_OK = 0                                   'user quit
        goto menu
'
'
Sub GoHome
        home
        waitms 2
End Sub
'
'
Sub Conv_displ
        Tmp1 = TmpLong mod 10                                 'tmp1 decimale
        TmpLong = TmpLong / 10                                'tmplong parte intera
        lcd TmpLong ; "," ; Tmp1;
End Sub
'
'
 'ritorna quando rileva un tasto premuto
Sub Taston
         do
           call Detasti
         loop until Tasti > 0
End Sub
'
'
'ritorna quando il tasto e rilasciato
Sub Tastoff
         do
           call Detasti
         loop until Tasti = 0
End Sub
'
'
Sub Detasti
         do
           Txx = P1 and MaskTasti                             'lettura tasto
           waitms 10
           Tasti = P1 and MaskTasti                           'lettura tasto
         loop until Txx = Tasti                               'Txx = Tasti
         Tasti = Tasti xor MaskTasti                          'inverte livello
End sub
'
'
'Frequency measure
'
Sub F_Measure
         counter1 = 0
         Hicntr = 0
         TmpW = 0                                             'timebase counter
         tcon.5 = 0                                           'TF0 clear
         start timer0
         bitwait tcon.5 , set                                 'wait tmr0 int
         tcon.6 = 1                                           'open timer1 gate
         tcon.5 = 0                                           'clear tf0
         ledM = ledOn
         do
           if tcon.7 = 1 then                                 'overflow tmr1
              incr Hicntr
              tcon.7 = 0                                      'clr tf1
           endif
           if tcon.5 = 1 then                                 'tmr0 int
              incr TmpW
              tcon.5 = 0
           endif
         loop until TmpW > 4998                               '4999 * 200uS = 0,9998S
'one more tmr0 int
         bitwait tcon.5 , set                                 'wait tmr0 int
         tcon.6 = 0                                           'close timer1 gate
         ledM = ledOff
         if tcon.7 = 1 then incr Hicntr                       'overflow tmr1 ?
         stop timer0
         mov  {TmpLong+0},{tl1}
         mov  {TmpLong+1},{th1}
         mov  {TmpLong+2},{Hicntr}
         mov  {TmpLong+3}, #0
End sub
'
'
'Period measure
'
Sub P_Measure
         Fl_Err = 0
         Fl_User = 0
         Fl_Phase = 0
         Fl_Done = 0
         tcon.6 = 0                                           'stop timer1
         Hicntr = 0                                           'prepare for measure
         TmpW = 0
         start timer0                                         'timeout time base
         tcon.0 = 1                                           'select INT0 edge
         counter1 = 0
         tcon.1 = 0                                           'clr INT0 flag
         ie = &B10000001                                      'enable EA & Int0
'
         do
            if tcon.7 = 1 then                                'overflow tmr1
               incr Hicntr
               tcon.7 = 0                                     'clr tf1
            endif
'timeout
            if tcon.5 = 1 then                                'tmr0 int
              incr TmpW
              tcon.5 = 0
              LedM = TmpW.9                                   'flash led wait measure
            endif
            if TmpW > 60000 then                              'check timeout
               Fl_Err = 1
               exit do
            endif
'
            if Ta_OK = 0 then
               Fl_user = 1
               exit do                                        'user quit
            endif
         loop until Fl_Done = 1                               'misura terminata
         mov  {TmpLong+0},tl1              'get t1
         mov  {TmpLong+1},th1
         if tcon.7 = 1 then                                   'overflow tmr1
            incr Hicntr                                       'update counter
         endif
         stop timer0
         mov  {TmpLong+2},{hicntr}
         mov  {TmpLong+3}, #0
         LedM = ledOff
End sub
'
'
Sub Too_long
         tcon.6 = 0                                           'stop timer1
         ie = 0                                               'disable int.
         home
         waitms 2
         lcd "--- Timeout ---"
         wait 1
End sub
'
'
Sub Clean
         lcd spc(15)                                          'elimina caratteri al fondo
End sub
'
'
$asm
'  fronte discesa misura periodo
.Int0_int:
         jb     {Fl_Phase},Pha_2  'fase lettura
         setb    tcon.6           'start timer1
         setb   {Fl_Phase}        'start misura
         sjmp   Intxt
Pha_2:
         clr    tcon.6            'stop timer1
         clr    ie.7              'disable EA
         setb   {Fl_Done}         'done
Intxt:
         reti
$end asm
'
'